* Title: Saving Time with Project Templates
* Slug: project-template
* Answers Common Question: Can I use Project templates?
* Answer Position: 2

================================================================

To save time when starting a new Project, use <{term}>Project Templates<{/term}>. You can create as many templates as needed and have reusable Projects readily available.

A Project template can be made scratch or generated from an existing Project.

<{sub}>Creating a New Project Templates from Scratch<{/sub}>

To create a new <{term}>Project Template<{/term}>, open the <{option}>Projects > Templates<{/option}> menu item. Use the <{option}>New Template<{/option}> button in the upper right corner to access the new template page. A tool similar to the <{page name="outline"}>Outline<{/page}> allows you to plan your Project by quickly creating  Milestones, Tasks and Subtasks, and applying all the necessary details (such as Category, Label, Priority).

You can even **predefine important Project phases** when creating a template by setting  <{term}>Milestone<{/term}> start and due dates. Note that the template dates are not fixed but relative. For instance, a Milestone has been set to start on day 1 and end on day 4 of a Project. If a Project is created from the template on July 1, the Milestone will also start on July 1 and end on July 4. The same rule also applies to <{term}>Tasks<{/term}> when setting a Task due date.

<{image name="new_template.png"}>

Besides Project structure, you can use Project Templates to define:

- <{option}>Positions<{/option}> - Instead of assigning actual users to Tasks on a template, you can create open positions (eg. designer, manager, tester), which you can fill when creating the Project from the template. Optionally, you can also set a default <{term}>Assignee<{/term}> to a position and save even more time. 
- <{option}>Attached Files<{/option}> - Upload Files that you wish to have available when the Project is created.
- <{option}>Task Categories<{/option}> - Add new and manage existing Task categories.
- <{option}>Discussion Categories<{/option}> - Set categories for Discussions.
- <{option}>File Categories<{/option}> - Set categories for Files.

<{related_video name="project-templates"}>

<{sub}>Creating a Project Template from an Existing Project<{/sub}>

It is possible to use your existing Project to create a Project template:

<{step num=1}>Open the <{option}>Project Overview<{/option}> page of the Project that you wish to convert to a template.<{/step}>
<{step num=2}>Open the <{term}>Options<{/term}> menu.<{/step}>
<{step num=3}>Choose the <{option}>Convert to a Template<{/option}> option.<{/step}>

<{image name="convert_to_template_zoom.png"}>

A pop-up  will appear, allowing you to set the details to be used in the template (such as  Name, Positions and Milestone list). After being created, the template can be edited to make final adjustments. 

<{note title="Editing the Project Template"}>To edit multiple items in your newly created Template, click the <{option}>Enter Mass Edit Mode<{/option}> button, available in the bottom right corner of the page. This option will enable you to change the Label, the Category or the Responsible person for all selected Milestones, Tasks and Subtasks.<{/note}>
